local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
    Asset( "ANIM", "anim/engineer.zip" ),
}

local prefabs = {"ehardhat", "tf2wrench", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap"}
local start_inv = {"ehardhat", "tf2wrench", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap", "scrap"}

local fn = function(inst)

    inst:AddTag("engie")
    inst.soundsname = "woodie"
    inst.MiniMapEntity:SetIcon( "engineer.tex" )
	
    -- Stats	
    inst.components.health:SetMaxHealth(125)
    inst.components.hunger:SetMax(150)
    inst.components.sanity:SetMax(200)

    inst.components.builder.science_bonus = 1
    inst.components.combat.damagemultiplier = TUNING.ENGIE_DMGDEBUFF --20% less
    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED

    --Crafting Recipes--

--GLOBAL.RECIPE_GAME_TYPE.COMMON

    local function AddModRecipe(name, ingredients, tab, techlevel, gametype, placer, min_spacing, nounlock, numtogive, aquatic, distance)
	if CAPY_DLC and IsDLCEnabled(CAPY_DLC) then
	    return Recipe(name, ingredients, tab, techlevel, gametype, placer, min_spacing, nounlock, numtogive, aquatic, distance)
	else
	    return Recipe(name, ingredients, tab, techlevel, placer, min_spacing, nounlock, numtogive)
	end
    end

    local modname = KnownModIndex:GetModActualName("The Engineer")

    --Scrap
    local recipe_difficulty = GetModConfigData("Scrap_Difficulty", modname)
    local ingredients = nil
    if recipe_difficulty == "default" then
	ingredients = {Ingredient("flint", 2), Ingredient("twigs", 2)}
    elseif recipe_difficulty == "easy" then
	ingredients = {Ingredient("flint", 1), Ingredient("twigs", 1)}
    elseif recipe_difficulty == "easier" then
	ingredients = {Ingredient("flint", 1)}
    elseif recipe_difficulty == "hard" then
	ingredients = {Ingredient("flint", 3), Ingredient("twigs", 3), Ingredient("goldnugget", 1)}
    elseif recipe_difficulty == "harder" then
	ingredients = {Ingredient("flint", 4), Ingredient("twigs", 4), Ingredient("goldnugget", 2)}
    end
    local scrap_recipe = AddModRecipe("scrap", ingredients, RECIPETABS.ENGIETAB, TECH.NONE, "common", nil, nil, nil, 5)
    scrap_recipe.atlas = "images/inventoryimages/scrap.xml"
    scrap_recipe.image = "scrap.tex"

    --Wrench
    local recipe_difficulty = GetModConfigData("tf2Wrench_Difficulty", modname)
    local ingredients = nil
    if recipe_difficulty == "default" then
	ingredients = {Ingredient("scrap", 5, "images/inventoryimages/scrap.xml"), Ingredient("twigs", 2), Ingredient("goldnugget", 1)}
    elseif recipe_difficulty == "harder" then
	ingredients = {Ingredient("scrap", 7, "images/inventoryimages/scrap.xml"), Ingredient("twigs", 4), Ingredient("goldnugget", 2)}
    elseif recipe_difficulty == "easier" then
	ingredients = {Ingredient("scrap", 5, "images/inventoryimages/scrap.xml"), Ingredient("twigs", 2)}
    end
    local tf2wrench_recipe = AddModRecipe("tf2wrench", ingredients, RECIPETABS.ENGIETAB, TECH.NONE)
    tf2wrench_recipe.atlas = "images/inventoryimages/tf2wrench.xml"
    tf2wrench_recipe.image = "tf2wrench.tex"

    --Hard hat
    local recipe_difficulty = GetModConfigData("EHat_Difficulty", modname)
    local ingredients = nil
    if recipe_difficulty == "default" then
	ingredients = {Ingredient("scrap", 4, "images/inventoryimages/scrap.xml"), Ingredient("goldnugget", 2)}
    elseif recipe_difficulty == "easy" then
	ingredients = {Ingredient("scrap", 2, "images/inventoryimages/scrap.xml"), Ingredient("goldnugget", 1)}
    elseif recipe_difficulty == "hard" then
	ingredients = {Ingredient("scrap", 6, "images/inventoryimages/scrap.xml"), Ingredient("goldnugget", 2)}
    elseif recipe_difficulty == "harder" then
	ingredients = {Ingredient("scrap", 8, "images/inventoryimages/scrap.xml"), Ingredient("goldnugget", 2), Ingredient("strawhat", 1)}
    end
    local ehardhat_recipe = AddModRecipe("ehardhat", ingredients, RECIPETABS.ENGIETAB, TECH.NONE)
    ehardhat_recipe.atlas = "images/inventoryimages/ehardhat.xml"
    ehardhat_recipe.image = "ehardhat.tex"
	
	    --Sentry gun
    local recipe_difficulty = GetModConfigData("Sentry_Difficulty", modname)
    local ingredients = nil
    local techlvl = TECH.NONE
    if recipe_difficulty == "default" then
	ingredients = {Ingredient("scrap", 20, "images/inventoryimages/scrap.xml"), Ingredient("gears", 3)}
    elseif recipe_difficulty == "hard" then
	ingredients = {Ingredient("scrap", 30, "images/inventoryimages/scrap.xml"), Ingredient("gears", 5), Ingredient("cutstone",5)}
    elseif recipe_difficulty == "harder" then
	techlvl = TECH.SCIENCE_TWO
	ingredients = {Ingredient("scrap", 40, "images/inventoryimages/scrap.xml"), Ingredient("gears", 5), Ingredient("goldnugget",5)}
    elseif recipe_difficulty == "easy" then
	ingredients = {Ingredient("scrap", 15, "images/inventoryimages/scrap.xml"), Ingredient("gears", 1)}
    end
    local esentry_item = AddModRecipe("esentry", ingredients, RECIPETABS.ENGIETAB, techlvl, "common", "esentry_placer")
    esentry_item.atlas = "images/inventoryimages/esentry.xml"
    esentry_item.image = "esentry.tex"

    --Gibus
    local gibus_recipe = AddModRecipe("gibus", {Ingredient("silk", 2), Ingredient("charcoal", 2)}, RECIPETABS.DRESS, TECH.NONE)
    gibus_recipe.atlas = "images/inventoryimages/gibus.xml"
    gibus_recipe.image = "gibus.tex"	

    --Dispenser
    local recipe_difficulty = GetModConfigData("Dispenser_Difficulty", modname)
    local ingredients = nil
    local techlvl = TECH.SCIENCE_TWO
    if recipe_difficulty == "default" then
	ingredients = {Ingredient("scrap", 15, "images/inventoryimages/scrap.xml"), Ingredient("redgem", 3)}
    elseif recipe_difficulty == "hard" then
	ingredients = {Ingredient("scrap", 25, "images/inventoryimages/scrap.xml"), Ingredient("redgem", 5), Ingredient("transistor",5)}
    elseif recipe_difficulty == "harder" then
	techlvl = TECH.MAGIC_TWO
	ingredients = {Ingredient("scrap", 35, "images/inventoryimages/scrap.xml"), Ingredient("redgem", 5), Ingredient("gears",5)}
    elseif recipe_difficulty == "easy" then
	ingredients = {Ingredient("scrap", 10, "images/inventoryimages/scrap.xml"), Ingredient("redgem", 1)}
    end
    local dispenser_recipe = AddModRecipe("dispenser", ingredients, RECIPETABS.ENGIETAB, techlvl, "common", "dispenser_placer")
    dispenser_recipe.atlas = "images/inventoryimages/dispenser.xml"
    dispenser_recipe.image = "dispenser.tex"

    --Tele entrance
    local recipe_difficulty = GetModConfigData("Teleporter_Difficulty", modname)
    local ingredients = nil
    local techlvl = TECH.MAGIC_TWO
    if recipe_difficulty == "default" then
	ingredients = {Ingredient("scrap", 15, "images/inventoryimages/scrap.xml"), Ingredient("nightmarefuel", 10)}
    elseif recipe_difficulty == "hard" then
	ingredients = {Ingredient("scrap", 20, "images/inventoryimages/scrap.xml"), Ingredient("nightmarefuel", 10), Ingredient("marble",5)}
    elseif recipe_difficulty == "harder" then
	ingredients = {Ingredient("scrap", 25, "images/inventoryimages/scrap.xml"), Ingredient("purplegem", 1), Ingredient("marble",10)}
    elseif recipe_difficulty == "easy" then
	techlvl = TECH.SCIENCE_TWO
	ingredients = {Ingredient("scrap", 10, "images/inventoryimages/scrap.xml"), Ingredient("nightmarefuel",6)}
    end
    local eteleporter_item = AddModRecipe("eteleporter", ingredients, RECIPETABS.ENGIETAB, techlvl, "common", "eteleporter_placer")
    eteleporter_item.atlas = "images/inventoryimages/eteleporter.xml"
    eteleporter_item.image = "eteleporter.tex"

    --Tele exit
    local recipe_difficulty = GetModConfigData("Teleporter_Difficulty", modname)
    local ingredients = nil
    local techlvl = TECH.MAGIC_TWO
    if recipe_difficulty == "default" then
	ingredients = {Ingredient("scrap", 15, "images/inventoryimages/scrap.xml"), Ingredient("nightmarefuel", 10)}
    elseif recipe_difficulty == "hard" then
	ingredients = {Ingredient("scrap", 20, "images/inventoryimages/scrap.xml"), Ingredient("nightmarefuel", 10), Ingredient("marble",5)}
    elseif recipe_difficulty == "harder" then
	ingredients = {Ingredient("scrap", 25, "images/inventoryimages/scrap.xml"), Ingredient("purplegem", 1), Ingredient("marble",10)}
    elseif recipe_difficulty == "easy" then
	techlvl = TECH.SCIENCE_TWO
	ingredients = {Ingredient("scrap", 10, "images/inventoryimages/scrap.xml"), Ingredient("nightmarefuel", 6)}
    end
    local eteleporter_exit_item = AddModRecipe("eteleporter_exit", ingredients, RECIPETABS.ENGIETAB, techlvl, "common", "eteleporter_exit_placer")
    eteleporter_exit_item.atlas = "images/inventoryimages/eteleporter.xml"
    eteleporter_exit_item.image = "eteleporter.tex"
end

return MakePlayerCharacter("engineer", prefabs, assets, fn, start_inv)